unit AOSingleMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DlsrLib_TLB, OleCtrls;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    SRAO: TDriverLINXSR;
    LDD: TDriverLINXLDD;
    cmdInit: TButton;
    cmdStart: TButton;
    lblStatus: TLabel;
    Label2: TLabel;
    txtVolts: TEdit;
    cboChannel: TComboBox;
    Label3: TLabel;
    Label4: TLabel;
    cboDevNumber: TComboBox;
    Label5: TLabel;
    procedure cmdInitClick(Sender: TObject);
    procedure cmdStartClick(Sender: TObject);
    procedure ServiceDone(Sender: TObject; var task, device, subsystem,
      mode: Smallint);
    procedure CloseDriver(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    AOdata : OleVariant;  // buffer for the data
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmdInitClick(Sender: TObject);
var
i : integer;
tempstr : string;
begin
// give the LDD control the driver name
ldd.Req_DLL_name := 'c:\drvlinx4\kmbdas8.dll';
ldd.device := cboDevNumber.ItemIndex;  // set your device number here
// fill in driver name above with your driver name
// 'kpci3108' for KPCI-3107 or KPCI-3108 boards
// 'kpci3100' for KPCI-3110 or KPCI-3116 or KPCI-3102 or KPCI-3104
// 'kpci1800' for KPCI-1800HC series boards
// 'kpcaiao' for KPCMCIA multifunction cards
// 'kmb1800' for DAS-1800 series
srao.Req_DLL_name := ldd.Req_DLL_name;
srao.Req_device := ldd.device;
// use LDD control to display full model name
ldd.Refresh;  // get current data for the driver/device
Form1.Caption := 'Polled Analog Output with ' + ldd.Dev_Model;

// populate combo box with channel numbers based on how many
// channels we have
   for i := 0 to (ldd.AO_nChan-1)
   do begin
   str(i,tempstr);
   cboChannel.Items.Add(tempstr);
   end;
   // set combo box equal to first entry
   cboChannel.ItemIndex := 0;

// initialize the hardware
  SRAO.Req_subsystem := DL_Device;  // entire device needs Initialized
  SRAO.Req_mode := DL_OTHER;
  SRAO.Req_op := DL_Initialize;
  SRAO.Refresh;
  lblStatus.Caption := SRAO.Message;  // display result

  form1.SetFocus;
  cboChannel.Enabled := True;
  cmdInit.Enabled := False;
  cmdStart.Enabled := True;
end;

procedure TForm1.cmdStartClick(Sender: TObject);
var
dummy : Double;
begin
SRAO.Req_op := DL_Start;
SRAO.Req_subsystem := DL_AO;
SRAO.Req_mode := DL_POLLED;

SRAO.Evt_Tim_type:= DL_NULLEvent;
SRAO.Evt_Str_type := DL_Command;
SRAO.Evt_Stp_type := DL_TCEvent;

SRAO.Sel_chan_N := 1;  // one channel only
SRAO.Sel_chan_start := cboChannel.ItemIndex;  // index same as the channel for us
SRAO.Sel_chan_startGainCode := SRAO.DLGain2Code(-1); // bipolar gain of 1 or
// -10 to +10 volt range

// single channel so do not need stop channel and gain
//SRAO.Sel_chan_stop := 0;
//SRAO.Sel_chan_stopGainCode := 0;
SRAO.Sel_buf_notify := DL_NOTIFY; // send messages

{*
   In order to be able to have your program deal in volts and to
   have it work for all possible ranges that the DAS-8/AO board might be
   configured to use, the code should make use of the ArrayBufferConvert
   method rather than the DLVolts2Code method.

   ArrayBufferConvert will (internally) make use of the LDD to know
   what the max and min voltages are for the channel and will calculate
   the appropriate DAC counts for that range.

   In contrast, the DLVolts2Code method always assumes a -10 to +10
   range.  If your channel is configured for a different range, then
   this method will not necessarily calculate the correct DAC counts
   for the requested voltage.

 *}

SRAO.Res_Sta_ioValue := SRAO.DLVolts2Code(StrToFloat(txtVolts.Text));



SRAO.Refresh;     //perform the task
lblStatus.Caption := 'Started AO with ' + SRAO.Message;
end;

procedure TForm1.ServiceDone(Sender: TObject; var task, device, subsystem,
  mode: Smallint);
begin
     beep;
     lblStatus.Caption := 'Voltage Value has been written';
end;

procedure TForm1.CloseDriver(Sender: TObject);
begin
// unload the driver for each object
SRAO.Req_DLL_name := '';
LDD.Req_DLL_name := '';
end;

procedure TForm1.FormCreate(Sender: TObject);
var
i : integer;
tempstr : string;
begin
// populate combo box with device numbers based
   for i := 0 to 5
   do begin
   str(i,tempstr);
   cboDevNumber.Items.Add(tempstr);
   end;
   // set combo box equal to first entry
   cboDevNumber.ItemIndex := 0;
end;

end.
